/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.server.data;

import dev.felnull.otyacraftengine.server.data.OEBaseSaveData;
import dev.felnull.otyacraftengine.util.OEPaths;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldDataManager {
    public static final Logger LOGGER = LogManager.getLogger(WorldDataManager.class);
    private static final WorldDataManager INSTANCE = new WorldDataManager();
    private final Map<class_2960, OEBaseSaveData> SAVE_DATA = new HashMap<class_2960, OEBaseSaveData>();

    public static WorldDataManager getInstance() {
        return INSTANCE;
    }

    public void register(class_2960 location, OEBaseSaveData saveData) {
        this.SAVE_DATA.put(location, saveData);
    }

    public <T extends OEBaseSaveData> T getSaveData(Class<T> aTClass) {
        for (OEBaseSaveData value : this.SAVE_DATA.values()) {
            if (((Object)((Object)value)).getClass() != aTClass) continue;
            return (T)((Object)value);
        }
        return null;
    }

    public void save(MinecraftServer server) {
        this.SAVE_DATA.forEach((n, m) -> {
            try {
                Path filePat = m.getSavePath() != null ? m.getSavePath() : Paths.get(n.method_12832() + ".dat", new String[0]);
                File file = OEPaths.getWorldSaveDataPath(server).resolve(n.method_12836()).resolve(filePat).toFile();
                file.toPath().getParent().toFile().mkdirs();
                m.method_17919(file);
            }
            catch (Exception e) {
                LOGGER.error("World save data save failure: [" + n + "]", (Throwable)e);
            }
        });
    }

    public void load(MinecraftServer server) {
        this.SAVE_DATA.forEach((n, m) -> {
            try {
                m.clear();
                Path filePat = m.getSavePath() != null ? m.getSavePath() : Paths.get(n.method_12832() + ".dat", new String[0]);
                File file = OEPaths.getWorldSaveDataPath(server).resolve(n.method_12836()).resolve(filePat).toFile();
                if (file.exists()) {
                    m.load(class_2507.method_30613((File)file).method_10562("data"));
                }
            }
            catch (IOException e) {
                LOGGER.error("World save data load failure: [" + n + "]", (Throwable)e);
            }
        });
    }

    public void unload() {
        this.SAVE_DATA.forEach((n, m) -> m.clear());
    }
}

